{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 12.09.98 - 13:04:40 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMConect, MMDSPObj, MMWavOut,
  MMHook, MMDesign, MMPLoad, MMWave, MMSystem, MMUtils;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    WaveOut: TMMWaveOut;
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnPreload: TButton;
    btnStop: TButton;
    btnPlay: TButton;
    Label1: TLabel;
    Preloader: TMMPreloader;
    WaveFile: TMMWaveFile;
    Label2: TLabel;
    lblTime: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnPreloadClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure PreloaderPreloaded(Sender: TObject);
    procedure PreloaderClose(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
    StartTime: Longint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ The component preloads some data so playback can start immediately.   }
{ If you call Preload, then the data will be loaded in memory and       }
{ the start command must not load the data from HD so it can start ASAP }

procedure TForm1.FormCreate(Sender: TObject);
begin
   WaveFile.Wave.FileName := 'E:\TRACK08.WAV';
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
   Preloader.Close;
end;

procedure TForm1.btnPreloadClick(Sender: TObject);
begin
   Label1.Caption := 'State: Loading';
   Label1.Update;

   Preloader.PreloadSize := 2*WaveOut.BufferSize*WaveOut.NumBuffers;
   Preloader.Preload;
end;

procedure TForm1.btnPlayClick(Sender: TObject);
begin
   StartTime := TimeGetTime;
   WaveOut.Start;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
end;

procedure TForm1.PreloaderPreloaded(Sender: TObject);
begin
   Label1.Caption := 'State: Done';
   Label1.Update;
end;

procedure TForm1.PreloaderClose(Sender: TObject);
begin
   Label1.Caption := 'State: Closed';
   Label1.Update;
end;

procedure TForm1.WaveOutStart(Sender: TObject);
begin
   { show the required time to start }
   lblTime.Caption := TimeToString(TimeGetTime-StartTime);

   btnPreload.Enabled := False;
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
end;

procedure TForm1.WaveOutStop(Sender: TObject);
begin
   btnPreload.Enabled := True;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
end;

end.
